document.addEventListener("DOMContentLoaded", function () {
    // Iegūst lietotāja datus no sesijas (dati tiek ielādēti no profile.php)
    fetch("profile.php?getUserData=true")
        .then(response => response.json())
        .then(userData => {
            if (userData) {
                document.getElementById("user-name").textContent = userData.first_name + " " + userData.last_name;
                document.getElementById("user-role").textContent = userData.work_position;
                document.getElementById("user-location").textContent = userData.country + ", " + userData.city;

                document.getElementById("first_name").value = userData.first_name;
                document.getElementById("last_name").value = userData.last_name;
                document.getElementById("email").value = userData.email;
                document.getElementById("phone").value = userData.phone_number;
                document.getElementById("user-work-position").value = userData.work_position;
                document.getElementById("user-contract").value = userData.contract_number;
            }
        })
        .catch(error => console.error("Kļūda ielādējot lietotāja datus:", error));

    // Iegūst un attēlo paziņojumus
    fetch("profile.php?getMessages=true")
        .then(response => response.json())
        .then(messages => {
            if (messages.success) {
                document.getElementById("success-message").textContent = messages.success;
            }
            if (messages.error) {
                document.getElementById("error-message").textContent = messages.error;
            }
        })
        .catch(error => console.error("Kļūda ielādējot paziņojumus:", error));
});
